/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.object;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IHandState;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IProgressData;
import dev.toma.gunsrpg.api.common.data.IReloadInfo;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.client.animation.RecoilAnimation;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.common.item.guns.ammo.IMaterialData;
import dev.toma.gunsrpg.common.item.guns.ammo.IMaterialDataContainer;
import dev.toma.gunsrpg.common.item.guns.setup.MaterialContainer;
import dev.toma.gunsrpg.common.item.guns.util.IAdditionalShootData;
import dev.toma.gunsrpg.common.item.guns.util.ScopeDataRegistry;
import dev.toma.gunsrpg.config.gun.WeaponConfig;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_SetReloadingPacket;
import dev.toma.gunsrpg.network.packet.C2S_ShootPacket;
import dev.toma.gunsrpg.util.object.OptionalObject;
import dev.toma.gunsrpg.util.properties.PropertyContext;
import javax.annotation.Nullable;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.IAnimationPipeline;
import net.minecraft.client.GameSettings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShootingManager {
    private static int shootingDelay;

    public static boolean canShoot(PlayerEntity player, ItemStack stack) {
        IPlayerData data = (IPlayerData)PlayerData.get(player).orElseThrow(NullPointerException::new);
        IReloadInfo reloadInfo = data.getReloadInfo();
        IProgressData levelData = data.getProgressData();
        GunItem item = (GunItem)stack.func_77973_b();
        if (!player.func_70051_ag() && ShootingManager.isShootingReady()) {
            ISkillProvider provider = data.getSkillProvider();
            if (!provider.hasSkill(item.getRequiredSkill())) {
                return false;
            }
            IAmmoMaterial material = item.getMaterialFromNBT(stack);
            if (material == null) {
                return false;
            }
            if (reloadInfo.isReloading()) {
                reloadInfo.enqueueCancel();
                if (player.field_70170_p.field_72995_K) {
                    NetworkManager.sendServerPacket(new C2S_SetReloadingPacket(false, 0));
                }
                return false;
            }
            if (data.getHandState().areHandsBusy()) {
                return false;
            }
            MaterialContainer container = item.getContainer();
            int weaponLevel = levelData.getWeaponStats(item).getLevel();
            IHandState state = data.getHandState();
            return item.hasAmmo(stack) && weaponLevel >= container.getRequiredLevel(material) && stack.func_77952_i() < stack.func_77958_k() && !item.isJammed(stack) && !state.areHandsBusy();
        }
        return false;
    }

    @Nullable
    public static GunItem getGunFrom(PlayerEntity player) {
        return player.func_184614_ca().func_77973_b() instanceof GunItem ? (GunItem)player.func_184614_ca().func_77973_b() : null;
    }

    public static void tickShootingDelay() {
        if (shootingDelay > 0) {
            --shootingDelay;
        }
    }

    public static boolean isShootingReady() {
        return shootingDelay <= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        private static final OptionalObject<Double> fov = OptionalObject.empty();
        private static final OptionalObject<Double> sensitivity = OptionalObject.empty();
        private static boolean burstActive;

        public static void shoot(PlayerEntity player, ItemStack stack, IPlayerData dataProvider) {
            boolean hasRecoil;
            GunItem gun = (GunItem)stack.func_77973_b();
            IAttributeProvider attributeProvider = dataProvider.getAttributes();
            AmmoType type = gun.getAmmoType();
            IAmmoMaterial material = gun.getMaterialFromNBT(stack);
            IMaterialDataContainer materialDataContainer = type.getContainer();
            WeaponConfig config = GunsRPG.config.weapon;
            float recoilModifier = config.globalWeaponRecoilMultiplier;
            if (materialDataContainer != null) {
                IMaterialData materialData = materialDataContainer.getMaterialData(material);
                recoilModifier += materialData.getAddedRecoil();
            }
            if (player.func_213453_ef()) {
                recoilModifier *= config.crouchWeaponRecoilMultiplier;
            }
            float xRot = gun.getVerticalRecoil(attributeProvider) * recoilModifier;
            float yRot = gun.getHorizontalRecoil(attributeProvider) * recoilModifier;
            boolean bl = hasRecoil = xRot != 0.0f || yRot != 0.0f;
            if (hasRecoil) {
                if (player.func_70681_au().nextBoolean()) {
                    yRot = -yRot;
                }
                player.field_70125_A -= xRot;
                player.field_70177_z -= yRot;
                IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
                pipeline.insert(ModAnimations.RECOIL, new RecoilAnimation(xRot, yRot, gun, stack, dataProvider));
            }
            NetworkManager.sendServerPacket(new C2S_ShootPacket(context -> {
                if (gun instanceof IAdditionalShootData) {
                    ((IAdditionalShootData)((Object)gun)).addExtraData((PropertyContext)context, player, stack, material);
                }
            }));
            gun.onShoot(player, stack);
            shootingDelay = gun.getFirerate(attributeProvider);
        }

        public static void saveSettings(GameSettings settings) {
            fov.map(settings.field_74334_X);
            sensitivity.map(settings.field_74341_c);
        }

        public static void loadSettings(GameSettings settings) {
            fov.ifPresent(value -> {
                settings.field_74334_X = value;
            });
            sensitivity.ifPresent(value -> {
                settings.field_74341_c = value;
            });
        }

        public static void applySettings(GameSettings settings, ScopeDataRegistry.Entry entry) {
            settings.field_74334_X = entry.getFov();
            settings.field_74341_c = sensitivity.get() * (double)entry.getSensitivityMultiplier();
        }

        public static void setBurstActive(boolean state) {
            burstActive = state;
        }

        public static boolean isBurstModeActive() {
            return burstActive;
        }

        public static void forceShootDelay(int delay) {
            shootingDelay = delay;
        }
    }
}

